function pageX(data, widgetId, callback, ap){
	$('#' + widgetId).next().find('.pageLeft').click(function(){
		if (!($(this).hasClass('disabled'))) {
			var ps = parseInt($('#' + widgetId).next().find('.pageStart').text());
			if (ps - 5 > 0) {
				if (ap) {
					callback(data, ps - 6, widgetId, ap);
				}
				else {
					callback(data, ps - 6, widgetId);
				}
			}
			else {
				if (ap) {
					callback(data, 0, widgetId, ap);
				}
				else {
					callback(data, 0, widgetId);
				}
			}
		}
	});
	
	$('#' + widgetId).next().find('.pageRight').click(function(){
		if (!($(this).hasClass('disabled'))) {
			var pe = parseInt($('#' + widgetId).next().find('.pageEnd').text());
			var pager = parseInt($('#' + widgetId + '_pager').text());
			if (pe + 1 <= pager) {
				if (ap) {
					callback(data,pe,widgetId,ap);
				}
				else {
					callback(data,pe,widgetId);
				}
			}
		}
	});
};

function wiCardWidget(widget) {
	
	function buildList(data, index, widgetId) {
		$('#' + widgetId).empty();
		var cardsToRender = data.slice(index, index + 5);
		$.each(cardsToRender, function(ix, wi){
			if (wi.Icon) {
				wiIcon = '<img src="' + imgUrl + wi.Icon + '">';
			}
			var wiType = wi.WorkItemType.split('.')[2];
			var wiCard = '<div class="cardBody"><div class="headerRow">' + wiIcon;
			wiCard += '<span class="wiLabel ' + wiType + '">' + wi.Id + ' - ' + wi.Title + '</span></div>';
			wiCard += '<p class="listDate">' + dateProp + ': ' + kendo.toString(new Date(wi[dateProp].toString() + 'Z'), "g") + '</p><p class="liBody">';
			$.each(props, function(z, p){
				wiCard += p + ': ' + wi[p.replace(' ','')] + (z == props.length - 1 ? '' : '</p><p>');
			})
			wiCard += '</p></div>';
			$('#' + widgetId).append("<a href='/" + wiType + "/Edit/" + wi.Id + "'><li class='homePageLi'>" + wiCard + "</li></a>");
		});
		
		$('#' + widgetId + '_pager').text(data.length.toString());
		$('#' + widgetId).next().find('.pageStart').text((index + 1).toString());
		if (index + 5 < data.length) {
			$('#' + widgetId).next().find('.pageEnd').text((index + 5).toString());
			$('#' + widgetId).next().find('.pageRight').removeClass('disabled');
		}
		else {
			$('#' + widgetId).next().find('.pageEnd').text(data.length.toString());
			$('#' + widgetId).next().find('.pageRight').addClass('disabled');
		}
		if (index == 0) {
			$('#' + widgetId).next().find('.pageLeft').addClass('disabled');
		}
		else {
			$('#' + widgetId).next().find('.pageLeft').removeClass('disabled');
		}
	}
	var imgUrl = "/Content/Images/Icons/WorkTypeIcons/";
	var url;
	var props = [];
	var dateProp;
	var wiIcon = '';
	var widgetId;
	var type = $(widget).hasClass('myrequests') ? 'myrequests' : 'mywork';
	
	switch(type) {
		case 'myrequests': {
			url = '/api/V3/WorkItem/GetGridWorkItemsMyRequests?userId=' + session.user.Id + '&showInactiveItems=false';
			props = ["Status"];
			dateProp = 'Created'
			widgetId = 'myRequests'
			break;
		}
		case 'mywork': {
			url = '/api/V3/WorkItem/GetGridWorkItemsByUser?userId=' + session.user.Id + '&isScoped=' +  session.user.Security.IsWorkItemScoped + '&showActivities=false&showInactiveItems=false';
			props = ["Status", "AffectedUser"];
			dateProp = 'LastModified',
			widgetId = 'myWork'
			break;
		}
	}
	$(widget).empty();
	$(widget).append('<ul id="' + widgetId + '" class="cardWidget"></ul>');
	$(widget).append('<div class="widgetFooter"><div class="pagingArea"><i class="fa fa-angle-double-left pageLeft"></i><span class="pageStart"></span> - <span class="pageEnd"></span> of <span id="' + widgetId + '_pager"></span><i class="fa fa-angle-double-right pageRight"></i></div></div>');
	$.get(url, function(data){
		buildList(data, 0, widgetId);
		pageX(data, widgetId, buildList);
		
	})
};

function topRequests(widget) {
	var url = '/api/V3/ServiceCatalog/GetTopRequestOffering?isScoped=' + session.user.Security.IsServiceCatalogScoped + '&returnAmount=5&userId=' + session.user.Id;
	var hov = $(widget).hasClass('horizontal') ? 'horizontal' : 'vertical';

	$(widget).empty();
	$(widget).addClass(hov);
	$(widget).append('<div id="roArea_top" class="roArea ' + hov + '"></div>');
	$.get(url, function(data) {
		$.each(data, function(i,e) {
			$('#roArea_top').append('<div class="roTile ' + hov + '"><a id="top_' + e.Id + '" href="/ServiceCatalog/RequestOffering/' + e.Id + ',' + e.ServiceInfo.Id + '"></a></div>');
			$('#top_' + e.Id).append('<div class="imgHolder"><img width="96" height="96" src="/ServiceCatalog/GetRequestOfferingImg/' + e.Id + '"></div>' + e.Title)
		});
	});
	
}

function favRequests(widget) {
	var url = '/ServiceCatalog/GetFavoriteRequestOffering';
	var hov = $(widget).hasClass('horizontal') ? 'horizontal' : 'vertical';

	$(widget).empty();
	$(widget).addClass(hov);
	$(widget).append('<div id="roArea_fav" class="roArea ' + hov + '"></div>');
	$.get(url, function(data) {
		$.each(data.Data, function(i,e) {
			$('#roArea_fav').append('<div class="roTile ' + hov + '"><a id="fav_' + e.Id + '" href="/ServiceCatalog/RequestOffering/' + e.Id + ',' + e.ServiceInfo.Id + '"></a></div>');
			$('#fav_' + e.Id).append('<div class="imgHolder"><img width="96" height="96" src="/ServiceCatalog/GetRequestOfferingImg/' + e.Id + '"></div>' + e.Title)
		});
	});
	
}

function topArticles(widget) {
	var type,url;
	type = $(widget).hasClass('featured') ? 'featured' : $(widget).hasClass('viewed') ? 'viewed' : '';
	
	switch (type) {
		case 'featured': {
			url = "/api/V3/Article/GetTopArticlesByPopularity?count=5";
			break;
		}
		case 'viewed': {
			url = "/api/V3/Article/GetTopArticlesByViewCount?count=5";
			break;
		}
		default: {
			url = "/api/V3/Article/GetTopArticlesByPopularity?count=5";
		}
	}
	$(widget).empty();
	$.get(url, function(data){
		$.each(data, function(i,e){
			$(widget).append('<li class="liArticle" id="kb' + e.ArticleId + '"><p class="liTitle">' + e.Title + '</p><p></p><p class="listDate">' + kendo.toString(new Date(e.LastModifiedDate.toString()), "g")  + '</p><p class="liBody">Rating: ' + e.Rating + '/5 </p><p class="listBody">Views: ' + e.ViewCount + '</p></li>');
			$('#kb' + e.ArticleId).click(function(){
				window.open('/KnowledgeBase/View/' + e.ArticleId, '_blank');
			});
		});
	});
	
}

function homeSearch(index, widget) {	
	var type,url,pm,onSelect,template;
	type = $(widget).hasClass('ro') ? 'ro' : $(widget).hasClass('kb') ? 'kb' : '';
	
	switch (type) {
		case "ro": {
			url = "/api/V3/ServiceCatalog/Search";
			pm = function(data, type) {
				if (type == "read") {
					return {
						searchText: data.filter.filters[0].value,
						searchType: "Requests",
						skipCount: 0,
						takeCount: 10
						
					}
				}
				else {
					return data;
				}
			};
			onSelect = function(select){
				window.open('/ServiceCatalog/RequestOffering/' + select.dataItem.Id + ',' + select.dataItem.ServiceOfferingId, '_self');
			};
			ktemplate = '<div class="homeListResult"><img class="listImage" src="/ServiceCatalog/GetRequestOfferingImg/#: data.Id #" ></img><span class="k-state-default"><h3>#: data.Title #</h3></span></div>';
			break;
		}
		case 'kb': {
			url = "/api/V3/ArticleList",
			pm = function(data, type) {
				if (type == "read") {
					return {
						searchText: data.filter.filters[0].value,
					}
				}
				else {
					return data;
				}
			};
			onSelect = function(select) {
				window.open('/KnowledgeBase/View/' + select.dataItem.ArticleId, '_self');
			};
			ktemplate = '<div class="homeListResult"><img class="listImage" src="/Content/Images/Icons/Drawer/kb-black.svg" ></img><span class="k-state-default"><h3>#: data.Title #</h3></span></div>';
			break;
		}
		default: {
			url = "/Search/GetFacetedSearchJsonResult";
			pm = function(data, type) {
				if (type == "read") {
					return {
						searchText: data.filter.filters[0].value,
					}
				}
				else {
					return data;
				}
			};
			onSelect= function (select){
				var surl;
				switch (select.dataItem.Type) {
					case 'KnowledgeArticle': {
						surl = '/KnowledgeBase/View/' + select.dataItem.Id;
						break;
					}
					case 'RequestOffering': {
						surl = '/ServiceCatalog/RequestOffering/' + select.dataItem.Id + ',' + select.dataItem.ServiceOfferingId;
						break;
					}
				}
				window.open(surl, '_self');
			};
			ktemplate = '<div class="homeListResult"><img class="listImage" src="#: data.Type == "RequestOffering" ? "/ServiceCatalog/GetRequestOfferingImg/" + data.Id : "/Content/Images/Icons/Drawer/kb-black.svg" #"></img>' +
	    '<span class="k-state-default"><h3>#: data.Title #</h3></span></div>';
		}
	}
	
	
	$(widget).empty();
	$(widget).append('<input type="text" id="homeSearch' + index.toString() + '"></input>');
	$('#homeSearch' + index.toString()).kendoAutoComplete({
		dataTextField: "Title",
		filter: "contains",
		minLength: 3,
		clearButton: true,
		dataSource: {
			serverFiltering: true,
			type: "json",
			transport: {
				read: {url: url}, 
				parameterMap: pm
			}
		},
		select: onSelect,
		template: ktemplate
	});
	
}

function homeCat(index, widget) {
	var id = "catBrowse" + index.toString();
	var foot = '<div class="widgetFooter"><div class="pagingArea"><i class="fa fa-angle-double-left pageLeft"></i><span class="pageStart"></span> - <span class="pageEnd"></span> of <span id="' + id + '_pager"></span><i class="fa fa-angle-double-right pageRight"></i></div></div>';
	
	function pageSetup(data, index, widgetId) {
		$('#' + widgetId + '_pager').text(data.length.toString());
		$('#' + widgetId).next().find('.pageStart').text((index + 1).toString());
		if (index + 5 < data.length) {
			$('#' + widgetId).next().find('.pageEnd').text((index + 5).toString());
			$('#' + widgetId).next().find('.pageRight').removeClass('disabled');
		}
		else {
			$('#' + widgetId).next().find('.pageEnd').text(data.length.toString());
			$('#' + widgetId).next().find('.pageRight').addClass('disabled');
		}
		if (index == 0) {
			$('#' + widgetId).next().find('.pageLeft').addClass('disabled');
		}
		else {
			$('#' + widgetId).next().find('.pageLeft').removeClass('disabled');
		}
		
	};
	
	function buildRoList(data, index, widgetId, soId) {
		$(widget).find('.widgetFooter').remove();
		if (data.length > 5) {
			$(widget).append(foot);	
		}
		
		$('#' + widgetId).find('.cardArea').empty();
		var cardsToRender = data.slice(index, index + 5);
		$.each(cardsToRender, function(ix, ro){
			var roIcon = '<img width="96" height="96" src="/ServiceCatalog/GetRequestOfferingImg/' + ro.RequestOfferingId + '">';
			var roCard = '<div class="cardBody"><div class="headerRow">' + roIcon;
			roCard += '<span class="roLabel">' + ro.RequestOfferingTitle + '</span></div></div>';
			$('#' + widgetId).find('.cardArea').append('<a href="/SC/ServiceCatalog/RequestOffering/' + ro.RequestOfferingId + ',' + soId + '"><li class="homePageLi">' + roCard + "</li></a>");
		});
		
		pageSetup(data, index, widgetId);
		pageX(data, widgetId, buildRoList, soId);
	}
	
	function buildSoList(data, index, widgetId) {
		$(widget).find('.widgetFooter').remove();
		if (data.length > 5) {
			$(widget).append(foot);	
		}
		
		$('#' + widgetId).find('.cardArea').empty();
		var cardsToRender = data.slice(index, index + 5);
		$.each(cardsToRender, function(ix, s){
			$('#' + id).find('.cardArea').append('<div class="serviceCard homePageLi"><img width="96" height="96" src="/ServiceCatalog/GetServiceOfferingImg/' + s.ServiceOfferingId + '" />' + s.Service + '</div>');
		});
		
		$('.serviceCard').each(function(i,e){
			$(e).click(function(el){
				//add to breadcrumb
				$('#' + widgetId).find('.browseTop').append('<span class="bcSeparator">></span><span class="bc so">' + $(el.target).text() + '</span>');
				var selectedCategory = data.filter(function(c){return c.Category == $('#' + id).find('.browseTop').text()})[0];
				var selectedSO = data.filter(function(s){return s.Service == $(el.target).text()})[0];
				
				buildRoList(selectedSO.requestofferings,0,id, selectedSO.ServiceOfferingId);
				
				//handle breadcrumb clicks
				$('.bc').each(function(x,so){
					$(so).click(function(e) {
					if ($(e.target).hasClass('so')) {
						$(so).prev().remove();
						$(so).remove();
						buildSoList(data, index, widgetId);
					}
				})
			
		})
			})
		})
		pageSetup(data, index, widgetId);
		pageX(data, widgetId, buildSoList)
	}
	
	function buildCategoryList(data, index, widgetId) {
		$(widget).find('.widgetFooter').remove();
		if (data.length > 5) {
			$(widget).append(foot);	
		}
		$('#' + widgetId).find('.cardArea').empty();
		var cardsToRender = data.slice(index, index + 5);
		$.each(cardsToRender, function(i, e) {
			$('#' + widgetId).find('.cardArea').append('<div class="catCard">' + e.Category + '</div>');
		})
		$('.catCard').each(function(x, o) {
			$(o).click(function(el){
				
				//start breadcrumb
				$('#' + widgetId).find('.browseTop').append('<span class="bc cat">' + $(el.target).text() + '</span>');
				var selectedCategory = data.filter(function(f){return f.Category == $(el.target).text()})[0];
				buildSoList(selectedCategory.services, 0, widgetId);
				
				//handle breadcrumb clicks
				$('.bc').each(function(i,e){
					$(e).click(function(el){
						if ($(el.target).hasClass('cat')) {
							homeCat(index, widget)
						}
					})
				})
			})
		})
		pageSetup(data, index, widgetId);
		pageX(data, widgetId, buildCategoryList);
		
	}
	
	var url = "/ServiceCatalog/GetServiceCatalogWithCatGroup";
	$(widget).empty();
	$(widget).append('<div id="' + id + '"><div class="browseTop"></div><div class="cardArea"></div></div>');

	$.get(url, function(data){
		buildCategoryList(data.Data, 0, id)	
	})
	
}
$(document).ready(function() {
	function homeWidgets(){
		$("<link>", {
            type: "text/css",
            rel: "stylesheet",
            href: '/CustomSpace/homeWidgets/style.css',
        }).appendTo("head");
		
		//top
		$('.margin-t20').prev().hide();
		
		//welcomeMessage
		var hour = new Date().getHours();
        var message = hour < 12 ? "Good morning " : hour > 17 ? "Good evening " : 'Good afternoon ';
		$('.welcomeMessage').parent().parent().parent().parent().prev().text(message + session.user.FirstName + '!');
		$('.welcomeMessage').parent().parent().parent().parent().prev().append('<i class="fa fa-times" id="closeWelcome"></i>');
		$('#closeWelcome').click(function() {
			$(this).parent().parent().hide();
			$(this).parent().parent().next().css('margin-top', '16px');
		});
		
		//WI Card widgets 
		$('.wiCardWidget').each(function(x,w) {
			wiCardWidget(w);
		})
		
		//service catalog - top and favorite
		$('.topRequests').each(function(i,e) {
			topRequests(e);
		});
		$('.favRequests').each(function(i,e) {
			favRequests(e);
		});
		
		//service catalog - browse
		$('.homeCat').each(function(i,e){
			homeCat(i,e);
		});
		
		//articles
		$('.topArticles').each(function(i,e) {
			topArticles(e);
		});
		
		//searches
		$('.homeSearch').each(function(i,e) {
			homeSearch(i, e);
		});
		
		
		//collapse panels
		$('.panel-heading').each(function(i,e){
			$(e).click(function(){
				$(this).toggleClass('panel-collapse');
				$(this).next().toggle();
			});
		});
		
		
	};
	var mainPageNode = document.getElementById('main_wrapper');
	var observer = new MutationObserver(function(mutations) {
		if ($('.dashboard').length > 0) {
			homeWidgets();
			observer.disconnect();
		}
		else {
			return;
		}
	});
	var observerConfig = { attributes: true, childList: true, subtree: true, characterData: true };
	observer.observe(mainPageNode, observerConfig);
	
});