//#########################################################//
/* ------------------------------------------------------- */
/* --------------- Custom Operation Status --------------- */
/* ------------------------------------------------------- */
// Tested with portal v10.0.0.2016
// Tested in Edge Chromium
// Contributors: Mikkel Madsen, Justin Workman
// Description: Creates a Operating Status page using the announcement function in the portal
// Notes: This script uses the W3.CSS framework - add it to your stylesheet to make it work correctly - se more: https://www.w3schools.com/w3css/default.asp
// v0.2 path to icons changed and icons included in sourcefiles
// v0.1 initial release

function OperatingStatus(scrollId) {
	
	//Get list of all announcements - CHANGE THE LANGUAGE CODE to match your environment
	var url = "/api/V3/Announcement/GetAllAnnouncements?languageCode=DAN";
	//variables to hold different types of announcements
	var criticalList = '';
	var mediumList = '';
	var lowList = '';
	var oldList = '';
	
	//first announcement id from list - is used to decide if we have to scroll to the announcement or not when hitting the page with an id
	var firstCriticalOrMedium = '';
	var firstLow = '';
	var firstOld = '';
	
	//HTML code to diplay if there are no announcements with priority critical or medium
	var noProblems = '<div name="noProblems" class="w3-section">' + 
					'<div class="w3-row">' +
						'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_green.svg" width="72px" height="72px"></div>' +
						'<div class="w3-cell w3-cell-middle"><div class="w3-large w3-text-blue">Ingen driftsforstyrrelser</div>' +
					'</div>' +
					'<div class="w3-container">' +
						'<div>Vi oplever ingen driftsforstyrrelser i øjeblikket.</div>' +
						'<div style="margin-bottom: 14px;">&nbsp;</div>' +
					'</div>' +	
				'</div>';
	
	//HTML code to diplay if there are no announcements with priority low
	var noUpcoming = '<div name="noUpcoming" class="w3-section">' + 
					'<div class="w3-row">' +
						'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_green.svg" width="72px" height="72px"></div>' +
						'<div class="w3-cell w3-cell-middle"><div class="w3-large w3-text-blue">Ingen planlagte driftsforstyrrelser</div>' +
					'</div>' +
					'<div class="w3-container">' +
						'<div>Der er ikke planlagt nogen driftsforstyrrelser i øjeblikket</div>' +
						'<div style="margin-bottom: 14px;">&nbsp;</div>' +
					'</div>' +	
				'</div>';
	
	//Builds the list of the different announcements
	function BuildAnnouncementList(aList) {
			
		//variables for styling purpose
		var borderTop = '';
		var borderTopLow = '';
		var borderTopOld = '';
		
		//for each announcement in the list, find the type and date and sort it
		$.each(aList, function(ii, a){
			
			//Current and upcoming announcements
			if (Date.parse(a.StartDate) <= Date.now() && Date.parse(a.EndDate) >  Date.now() ) {
				
				switch (a.PriorityId) {
					//Critical Priority - add the html code to the list of critical announcements
					case 'f10a51c2-c569-4e64-8237-2b117d63ddb8': {
						criticalList += '<div name="criticalItem" id="' + a.Id + '" class="w3-section">' + 
											'<div class="w3-row ' + borderTop + '">' +
												'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_red.svg" width="72px" height="72px"></div>' +
												'<div class="w3-cell w3-cell-middle"><div class="w3-large w3-text-blue">' + a.Title + '</div><div class="listDate">Oprettet: ' + kendo.toString(new Date((a.StartDate + 'Z').toString()), "g") + '</div></div>' +
											'</div>' +
											'<div class="w3-container">' +
												'<div class="">'+ a.Body + '</div>' +
											'</div>' +	
										'</div>';
											
						borderTop = 'w3-border-top';
						if (firstCriticalOrMedium == '')
						{
							firstCriticalOrMedium = a.Id;
						}
						break;
					}
					//Medium Priority - add the html code to the list of medium announcements
					case '64096f7f-f8e0-491c-a7fe-94fedded4715': {
						mediumList += '<div name="mediumItem" id="' + a.Id + '"  class="w3-section">' + 
											'<div class="w3-row ' + borderTop + '">' +
												'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_yellow.svg" width="72px" height="72px"></div>' +
												'<div class="w3-cell w3-cell-middle"><div class="w3-large w3-text-blue">' + a.Title + '</div><div class="listDate">Oprettet: ' + kendo.toString(new Date((a.StartDate + 'Z').toString()), "g") + '</div></div>' +
											'</div>' +
											'<div class="w3-container">' +
												'<div>'+ a.Body + '</div>' +
											'</div>' +	
										'</div>';
						borderTop = 'w3-border-top';
						if (firstCriticalOrMedium == '')
						{
							firstCriticalOrMedium = a.Id;
						}
						break;
					}
					//Low Priority - add the html code to the list of low announcements
					case 'f860661b-d9d6-41cb-a501-467b4dd81a7b': {
						lowList += '<div name="lowItem" id="' + a.Id + '"  class="w3-section" >' + 
											'<div class="w3-row ' + borderTopLow + '">' +
												'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_blue.svg" width="72px" height="72px"></div>' +
												'<div class="w3-cell w3-cell-middle"><div class="w3-large w3-text-blue">' + a.Title + '</div><div class="listDate">Oprettet: ' + kendo.toString(new Date((a.StartDate + 'Z').toString()), "g") + '</div></div>' +
											'</div>' +
											'<div class="w3-container">' +
												'<div>'+ a.Body + '</div>' +
											'</div>' +	
										'</div>';
						borderTopLow = 'w3-border-top';
						//lowListCount++;
						if (firstLow == '')
						{
							firstLow = a.Id;
						}
						
						break;
					}
					default: {console.log('default match');}
				}
			
			}
			else if(Date.parse(a.EndDate) <  Date.now()){ //previously announcements

						oldList += '<div name="oldItem" id="' + a.Id + '"  class="w3-section" >' + 
											'<div class="w3-row ' + borderTopOld + '">' +
												'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_gray.svg" width="72px" height="72px"></div>' +
			'<div class="w3-cell w3-cell-middle"><div class="w3-large w3-text-blue">' + a.Title + '</div><div class="listDate">Oprettet: ' + kendo.toString(new Date((a.StartDate + 'Z').toString()), "g") + '</div></div>' +
											'</div>' +
											'<div class="w3-container">' +
												'<div>'+ a.Body + '</div>' +
											'</div>' +	
										'</div>';
						borderTopOld = 'w3-border-top';
						if (firstOld == '')
						{
							firstOld = a.Id;
						}
				
			}
			
			
			
		});
		
		//We are not using the messagecontainer so we are removing it the free up space
		$('#alertMessagesContainer').remove();
		
		//Styles the current operating status with a rounded border and adds an icon
		$('.currentOperatingStatus').parent().parent().parent().parent().attr("class", "w3-border w3-border-grey w3-round-large");
		$('.currentOperatingStatus').parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-bullhorn panel-title-icon"> </i>');

		//Styles the upcoming operating status with a rounded border and adds an icon
		$('.upcomingOperatingStatus').parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-calendar panel-title-icon"> </i>');
		$('.upcomingOperatingStatus').parent().parent().parent().parent().attr("class", "w3-border w3-border-grey w3-round-large");
		
		//Styles the previously operating statuses with a rounded border and adds an icon
		$('.prevOperatingStatus').parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-calendar-o panel-title-icon"> </i>');
		$('.prevOperatingStatus').parent().parent().parent().parent().attr("class", "w3-border w3-border-grey w3-round-large");
		$('.prevOperatingStatus').parent().parent().parent().parent().prev().children('div').attr("class", "w3-margin-top");

		//Clears the widgets to make sure its empty
		$('.currentOperatingStatus').empty();
		$('.upcomingOperatingStatus').empty();
		$('.prevOperatingStatus').empty();

		//If there are no critical og medium announcements - add the no problems html code
		if(criticalList == '' && mediumList == ''){
			$('.currentOperatingStatus').append(noProblems);
		}
		//Else add the lists om critical and medium announcements
		else {
			$('.currentOperatingStatus').append(criticalList);
			$('.currentOperatingStatus').append(mediumList);
		}
		
		//If there are not upcoming events - add the no upcoming html code
		if(lowList == ''){
			$('.upcomingOperatingStatus').append(noUpcoming);
		}
		//Else add the list of upcoming events
		else{
			$('.upcomingOperatingStatus').append(lowList);
		}	
			
		//If there are no old events - don't show anything
		if(oldList == ''){
		}
		//Else show the list with old announcements
		else{
			$('.prevOperatingStatus').append(oldList);
		}
		
		//If there is an announcement id in the URL - find out if we have to scroll to it		
		if(scrollId){
			
			switch(scrollId){
				//Do nothing if it is the first critical, medium or low announcement
				case firstCriticalOrMedium :{console.log('firstCriticalOrMedium match')}
				case firstLow : {console.log('firstLow');break;}
				//If its the first old - make special scroll
				case firstOld :  {console.log('firstOld');
					$("body,html").animate(
						{
							scrollTop: $("#" + scrollId).offset().top - 150
						}, 1000);
					break;}
				//Else scroll to the announcement
				default : {
					$("body,html").animate(
						{
							scrollTop: $("#" + scrollId).offset().top - 90
						}, 1000);
				}
			}
		}
	}
	
	//Get the announcements and build the announcement lists
	$.get(url, function(data) {
			BuildAnnouncementList(data);
	});

};

$(document).ready(function() {
	function StartOperatingStatus(){
		//Adds stylesheet
		$("<link>", {
            type: "text/css",
            rel: "stylesheet",
            href: '/CustomSpace/EndUserHome/style.css',
        }).appendTo("head");
		
		//hides top
		$('.margin-t20').prev().hide();
		
		//function to get the parameter from the URL		
		var getParameterByName = function(name, url) {
			if (!url) {
				url = window.location.href;
			}
			name = name.replace(/[\[\]]/g, "\\$&");
			var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
				results = regex.exec(url);
			if (!results) return null;
			if (!results[2]) return '';
			return decodeURIComponent(results[2].replace(/\+/g, " "));
		}
		
		//Get paramenter with name 'id'
		var id = getParameterByName('id');
		//Build the page
		OperatingStatus(id);
	}
	
	var mainPageNode = document.getElementById('main_wrapper');
	var observer = new MutationObserver(function(mutations) {
		if ($('.dashboard').length > 0) {
			observer.disconnect();
			StartOperatingStatus();
		}
		else {
			return;
		}
	});
	var observerConfig = { attributes: true, childList: true, subtree: true, characterData: true };
	observer.observe(mainPageNode, observerConfig);
	
});

/* ------------------------------------------------------- */
/* ------------- End Custom Operation Status ------------- */
/* ------------------------------------------------------- */ 