$(document).ready(function() {
	//variable to the custom announcement page in the portal
	var aPageUrl = 'http://test-cireson02/Page/7074e08a-ed22-46fa-b06f-9d59d90d5c70';
	
	
	//This function creates a button above the announcement editor which copy the announcement title and creates a link directly the announcement on a custom announcement page
	function SikoLink(){
		//code for copy link button
		var sikoButton = '<li class="w3-right" >' + 
								'<button id="copyLink" role="button" unselectable="on"><i class="fa fa-clipboard"><span class="w3-margin-left">Copy link to Siko</span></button>' +
						'</li>';
		
		//Appending the button to the editor toolbar on the edit announcement page
		$('ul[data-role="editortoolbar"]').append(sikoButton);
		
		//Add click event to the copy button
		$('#copyLink').on('click', function(){
			//Creates a textarea element to hold the text we want to copy to the clipboard
			var copyTextarea = 	'<textarea id="copyText" class="w3-text-white">' +
									pageForm.viewModel.Title +
									'\r\nSe mere og følg status på: ' + aPageUrl + '?id=' + pageForm.viewModel.Id +
								'</textarea>';
			//append the hidden textarea to the alertMessagesContainer and make it visible else we will not be able to copy to clipboard
			$("#alertMessagesContainer").append(copyTextarea).show();	
			
			//copy the text from the textarea to the clipboard
			var copyTextElement = $('#copyText');
			copyTextElement.focus();
			copyTextElement.select();
			document.execCommand("copy");
			//remove the textarea element again so we don't see it.
			$("#alertMessagesContainer").empty();
			//append element that informs that it is copied and ready to paste on intranet
			$("#alertMessagesContainer").append('<div class="alert alert-success">Overskrift og link er nu kopieret til udklipsholderen og klar til at sætte ind på Siko ved brug af "Ctrl + v"</div>');
			//Shows the element for a while - then hides it again
			$("#alertMessagesContainer:first").show(200).delay(6000).slideToggle(800, function(){$("#alertMessagesContainer").empty();});
		});
	}
	
	
	var mainPageNode = document.getElementById('main_wrapper');
	var observer = new MutationObserver(function(mutations) {
		if ($('ul[data-role="editortoolbar"]').length > 0) {
			observer.disconnect();
			SikoLink();
		}
		else {
			return;
		}
	});
	var observerConfig = { attributes: true, childList: true, subtree: true, characterData: true };
	observer.observe(mainPageNode, observerConfig);
	
});