//#########################################################//
/* ------------------------------------------------------- */
/* ------------ Custom Alternate End Use Home ------------ */
/* ------------------------------------------------------- */
// Tested with portal v10.0.0.2016
// Tested in Edge Chromium
// Contributors: Mikkel Madsen, Justin Workman
// Description: Widgets to be used with an alternate End User Home
// Notes: This script uses the W3.CSS framework - add it to your stylesheet to make it work correctly - se more: https://www.w3schools.com/w3css/default.asp
// v0.2 path to icons changed and icons included in sourcefiles
// v0.1 initial release

//Function to make a browse menu - back and forth 5 items at a time - to be placed as a footer in a widget
function pageX(data, widgetId, callback, ap){
	$('#' + widgetId).next().find('.pageLeft').click(function(){
		if (!($(this).hasClass('disabled'))) {
			var ps = parseInt($('#' + widgetId).next().find('.pageStart').text());
			if (ps - 5 > 0) {
				if (ap) {
					callback(data, ps - 6, widgetId, ap);
				}
				else {
					callback(data, ps - 6, widgetId);
				}
			}
			else {
				if (ap) {
					callback(data, 0, widgetId, ap);
				}
				else {
					callback(data, 0, widgetId);
				}
			}
		}
	});
	
	$('#' + widgetId).next().find('.pageRight').click(function(){
		if (!($(this).hasClass('disabled'))) {
			var pe = parseInt($('#' + widgetId).next().find('.pageEnd').text());
			var pager = parseInt($('#' + widgetId + '_pager').text());
			if (pe + 1 <= pager) {
				if (ap) {
					callback(data,pe,widgetId,ap);
				}
				else {
					callback(data,pe,widgetId);
				}
			}
		}
	});
};

//Workiten card widget - Creates a widget with list of workitems of either "My Requests" og "My Work"
function wiCardWidget(widget) {
	
	function buildList(data, index, widgetId) {
		
		//Clear the old widget to be sure its empty
		$('#' + widgetId).empty();
		//pick only 5 work items to show
		var cardsToRender = data.slice(index, index + 5);
		//Holds track on the last workitem in the list - to remove bottom border on last wi card
		var lastRequest;
		
		$.each(cardsToRender, function(ix, wi){
			//Sets the url for icon matching the workitem type
			if (wi.Icon) {
				wiIcon = '<img src="' + imgUrl + wi.Icon + '">';
			}
			var wiType = wi.WorkItemType.split('.')[2];
			//Different status colors depending on the status of the workitem
			var wiStatusColor = ''
			
			switch(wi.Status) {
				case 'New':
				case 'Submitted':
				case 'In Progress':
				case 'Active':
				{
					wiStatusColor = 'w3-text-blue';
					break;
				}
				case 'Pending':
				case 'On Hold':
				{
					wiStatusColor = 'w3-text-red';
					break;
				}
				case 'Completed':
				case 'Resolved':
				{
					wiStatusColor = 'w3-text-green';
					break;
				}
			}
			
			//Html code for the Work Item card
			var wiCard = '<div id="' + wi.Id + '"class="w3-container">' + 
							'<div class="w3-large">' + wiIcon +
								'<span class="w3-margin-left ' + wiType + '">' + wi.Id + ' - ' + wi.Title + '</span>' + //wiType necessary here??
							'</div>' +
							'<div class="liBody">Oprettet: <span class="w3-text-grey">' + kendo.toString(new Date(wi[dateProp].toString() + 'Z'), "g") + '</span><span class="w3-right">Status: <span class="' + wiStatusColor + '">' + wi.Status + '</span></span></div>' +
							'<div class="liBody">Sidst opdatet: <span class="w3-text-grey">' + kendo.toString(new Date(wi[dateProp].toString() + 'Z'), "g") + '</span></div>' +
						'</div>';

			//Add the workitem card to the widget and make hover effect on it
			$('#' + widgetId).append("<div class='w3-border-bottom w3-padding-16 w3-hover-light-grey w3-hover-shadow' style='cursor: pointer;'>" + wiCard + "</div>");
			
			//Add eventhandling to the card - opens the workitem when clicked
			$('#' + wi.Id).on("click", function(e){
				wiUrl = '/' + wiType + '/Edit/' + wi.Id;
				window.open( wiUrl, "_self");
			});
			//Keeps track on what the last 
			lastRequest = '#' + wi.Id;
		});
		
		//Removes bottom border on last element
		$(lastRequest).parent().removeClass('w3-border-bottom');

		//Builds the navigation menu to browse the list of work items
		$('#' + widgetId + '_pager').text(data.length.toString());
		$('#' + widgetId).next().find('.pageStart').text((index + 1).toString());
		if (index + 5 < data.length) {
			$('#' + widgetId).next().find('.pageEnd').text((index + 5).toString());
			$('#' + widgetId).next().find('.pageRight').removeClass('disabled');
		}
		else {
			$('#' + widgetId).next().find('.pageEnd').text(data.length.toString());
			$('#' + widgetId).next().find('.pageRight').addClass('disabled');
		}
		if (index == 0) {
			$('#' + widgetId).next().find('.pageLeft').addClass('disabled');
		}
		else {
			$('#' + widgetId).next().find('.pageLeft').removeClass('disabled');
		}
	}
	
	//Path to workitem icons
	var imgUrl = "/Content/Images/Icons/WorkTypeIcons/";
	var url;
	var props = [];
	var dateProp;
	//var created;
	//var lastModified;
	var wiIcon = '';
	var widgetId;
	var type = $(widget).hasClass('myrequests') ? 'myrequests' : 'mywork';
	
	switch(type) {
		//Build the widget with workitem cards from from "My Request" list 
		case 'myrequests': {
			//Url to get my request list
			url = '/api/V3/WorkItem/GetGridWorkItemsMyRequests?userId=' + session.user.Id + '&showInactiveItems=false';
			props = ["Status"];
			dateProp = 'Created';
			widgetId = 'myRequests';
			//Add hover event on widget headline
			$(widget).parent().parent().parent().parent().prev().addClass('panelHeadingHover');
			//Add text/button to show all - opens "My Requests" site
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').append('<span class="w3-right w3-margin-top w3-medium"><a href="/View/c5161e06-2378-4b44-aa89-5600e2d3b9d8">(Se alle)</a></span>');
			//Add icon before widget headline text
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-comment panel-title-icon"> </i>');

			break;//cursor: pointer
		}
		//Build the widget with workitem cards from from "My Work" list 
		case 'mywork': {
			//Url to get my work list
			url = '/api/V3/WorkItem/GetGridWorkItemsByUser?userId=' + session.user.Id + '&isScoped=' +  session.user.Security.IsWorkItemScoped + '&showActivities=false&showInactiveItems=false';
			props = ["Status", "AffectedUser"];
			dateProp = 'LastModified';
			widgetId = 'myWork';
			//Add hover event on widget headline
			$(widget).parent().parent().parent().parent().prev().addClass('panelHeadingHover');
			//Add text/button to show all - opens "My Work" site
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').append('<span class="w3-right w3-margin-top w3-medium"><a href="/View/cca5abda-6803-4833-accd-d59a43e2d2cf">(Se alle)</a></span>');
			//Add icon before widget headline text
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-user panel-title-icon"> </i>');
			
			break;
		}
	}
	
	//Clear the old widget to be sure its empty
	$(widget).empty();
	
	$(widget).append('<div id="' + widgetId + '" class=""></div>');
	//Add footer browse buttons
	$(widget).append('<div class="widgetFooter"><div class="pagingArea"><i class="fa fa-angle-double-left pageLeft"></i><span class="pageStart"></span> - <span class="pageEnd"></span> of <span id="' + widgetId + '_pager"></span><i class="fa fa-angle-double-right pageRight"></i></div></div>');

	//Add rounded border around the list with work item cards
	$(widget).parent().parent().parent().parent().attr("class", "w3-border w3-border-grey w3-round-large");

	//Get list of work items end build the Work item card list
	$.get(url, function(data){
		buildList(data, 0, widgetId);
		pageX(data, widgetId, buildList);
		
	})
}

//Widget with Operating Status - uses announcement as source for status messages
// ** Status explanation **
// ** Critical - Major error affecting vital systems or many users - Red colored error icon
// ** Medium - Minor error affecting non-vital systems or only subset of users - Yellow colored error icon
// ** Low - Planned operational disruption - Blue colored error icon
//
function OperatingStatus(widget) {
	//Get list of announcement targeted the portal user
	var url = "/api/V3/Announcement/GetUserAnnouncements?userId=" + session.user.Id + "&languageCode=DAN";
	//URL to custom page with announcements
	var aUrl = "http://test-cireson02/Page/7074e08a-ed22-46fa-b06f-9d59d90d5c70";

	//Function to build the html code for the Announcement list widget
	function BuildAnnouncementList(aList) {
			
		//Annoucements with status Critical
		var criticalList = '';
		//Annoucements with status Medium
		var mediumList = '';
		//Annoucements with status Low
		var lowList = '';
		//Holds track on how many Annoucements with status low
		var lowListCount = 0;
		//var oldList = '';
		
		//Hmtl code to use when no Annoucements with status critical or medium exists
		var noProblems = '<div name="noProblems" class="w3-section">' + 
							'<div class="w3-row">' +
								'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_green.svg" width="72px" height="72px"></div>' +
								'<div class="w3-cell w3-cell-middle"><div class="w3-large">Ingen driftsforstyrrelser</div>' +
							'</div>' +
							'<div class="w3-container">' +
								'<div>Vi oplever ingen driftsforstyrrelser i øjeblikket.</div>' +
								'<div style="margin-bottom: 14px;">&nbsp;</div>' +
							'</div>' +	
						'</div>';
		
		//variable to define if there should be a top border in the statuslist
		var borderTop = '';
		
		//Reads all announcements and splits them up into catagories - Critical, Medium, Low
		$.each(aList, function(ii, a){
			
			switch (a.PriorityId) {
				//Critical Priority
				case 'f10a51c2-c569-4e64-8237-2b117d63ddb8': {
					//Build the html code for an announcement with critical status
					criticalList += '<div name="criticalItem" class="w3-section">' + 
										'<div class="w3-row ' + borderTop + '">' +
											'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_red.svg" width="72px" height="72px"></div>' +
											'<div class="w3-cell w3-cell-middle"><div class="w3-large"><a href="' + aUrl + '?id=' + a.Id + '" style="text-decoration: none; font-weight: bold;">' + a.Title + '</a></div><div class="listDate">Oprettet: ' + kendo.toString(new Date((a.StartDate + 'Z').toString()), "g") + '</div></div>' +
										'</div>' +
										'<div class="w3-container">' +
											'<div class="">'+ a.Body + '</div>' +
										'</div>' +	
									'</div>';
					//Set the variable to have a top border if there are more announcements					
					borderTop = 'w3-border-top';
					break;
				}
				//Medium Priority
				case '64096f7f-f8e0-491c-a7fe-94fedded4715': {
					//Build the html code for an announcement with medium status
					mediumList += '<div name="mediumItem" class="w3-section">' + 
										'<div class="w3-row ' + borderTop + '">' +
											'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_yellow.svg" width="72px" height="72px"></div>' +
											'<div class="w3-cell w3-cell-middle"><div class="w3-large"><a href="' + aUrl + '?id=' + a.Id + '" style="text-decoration: none; font-weight: bold;">' + a.Title + '</a></div><div class="listDate">Oprettet: ' + kendo.toString(new Date((a.StartDate + 'Z').toString()), "g") + '</div></div>' +
										'</div>' +
										'<div class="w3-container">' +
											'<div>'+ a.Body + '</div>' +
										'</div>' +	
									'</div>';
					
					//Set the variable to have a top border if there are more announcements					
					borderTop = 'w3-border-top';

					break;
				}
				//Low Priority
				case 'f860661b-d9d6-41cb-a501-467b4dd81a7b': {
					//Build the html code for an announcement with medium status
					lowList += '<div name="lowItem" class="w3-section displayNone" >' + 
										'<div class="w3-row ' + borderTop + '">' +
											'<div class="w3-cell"><img src="/CustomSpace/EndUserHome/Icons/Data-Error_blue.svg" width="72px" height="72px"></div>' +
											'<div class="w3-cell w3-cell-middle"><div class="w3-large"><a href="' + aUrl + '?id=' + a.Id + '" style="text-decoration: none">' + a.Title + '</a></div><div class="listDate">Oprettet: ' + kendo.toString(new Date((a.StartDate + 'Z').toString()), "g") + '</div></div>' +
										'</div>' +
										'<div class="w3-container">' +
											'<div>'+ a.Body + '</div>' +
										'</div>' +	
									'</div>';

					//Set the variable to have a top border if there are more announcements					
					borderTop = 'w3-border-top';
					//Adds one to the counter of planned disruptions
					lowListCount++;
					break;
				}
			}
		});
		
		//Add rounded border around the list with operating status messages
		$(widget).parent().parent().parent().parent().attr("class", "w3-border w3-border-grey w3-round-large");
		//Add hover event on widget headline
		$(widget).parent().parent().parent().parent().prev().addClass('panelHeadingHover');

		//Add critical list to the widget
		$('.operatingStatus').append(criticalList);
		//Add medium list to the widget
		$('.operatingStatus').append(mediumList);
		
		//If no critical or medium messages - Add no problems code instead
		if(criticalList == '' && mediumList == ''){
			$('.operatingStatus').append(noProblems);
		}
			
		//var lowListCountText = 'Ingen';
		//if (lowListCount > 0){lowListCountText = lowListCount;}
		//Text to show in counter of planned disruptions
		lowListCountText = lowListCount > 0 ? lowListCount : 'Ingen';
		
		//Html code for planned operational disruption headline
		var lowItemHeader = '<div id="lowItemHeader" class="w3-padding w3-border-top">' + 
								'<div class="w3-large w3-text-blue">' + lowListCountText + ' planlagte driftsforstyrrelser <i id="upcomingEvents" class="w3-text-black w3-right" ></i></div>' +
							'</div>';
		
		
		//Add the headline to the widget
		$('.operatingStatus').append(lowItemHeader);
		
		// Dropdown function if there are one or more planned disruptions
		if(lowListCount > 0) {
			$('#upcomingEvents').addClass("fa fa-caret-down");
			
				$('#lowItemHeader').on('click', function(){
				$('[name="lowItem"]').toggleClass('displayNone');
				
				if($('#upcomingEvents').hasClass("fa fa-caret-down"))
				{
					$('#upcomingEvents').removeClass("fa fa-caret-down");
					$('#upcomingEvents').addClass("fa fa-caret-up");
				}
				else{
					$('#upcomingEvents').removeClass("fa fa-caret-up");
					$('#upcomingEvents').addClass("fa fa-caret-down");
				}

			});
		}
		//Add the planned disruption list to the widget
		$('.operatingStatus').append(lowList);

	}
	
	//Clear the old widget to be sure its empty
	$(widget).empty();
	
	//Get list of announcement targeted the portal user and build the operational status widget
	$.get(url, function(data) {
			//Adds icon before widget title text
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-bullhorn panel-title-icon"> </i>');

			//Append list to target with list items
			BuildAnnouncementList(data);
	});

};

function topArticles(widget) {
	var type,url,widgetId;
	
	function buildKbList(data, widgetId) {
		
		$('#' + widgetId).empty();
		//var cardsToRender = data.slice(index, index + 5);
		
		var lastArticle;
		
		$.each(data, function(ix, kb){
			
			var kbAbst = kb.Abstract.slice(0, 100);
			var kbRating = '<i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i>';
			
			switch (kb.Rating){
				case 1: {
					kbRating = '<i class="fa fa-star"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i>';
					break;}
				case 2: {
					kbRating = '<i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i>';
					break;}
				case 3: {
					kbRating = '<i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i>';
					break;}
				case 4: {
					kbRating = '<i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star-o"></i>';
					break;}
				case 5: {
					kbRating = '<i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i><i class="fa fa-star"></i>';
					break;}
			
			}
			
			var kbCard = '<div id="kb' + kb.ArticleId + '" class="w3-container">' + 
							'<div class="w3-large">' + kb.Title + '</div>' +
							'<div class="liBody" style="font-style: italic;">' + kbAbst + '...</div>' +
							'<div class="liBody">Rating: <span class="w3-text-grey">' + kbRating + '</span><span class="w3-margin-left">Visninger: <span class="w3-text-grey">' + kb.ViewCount + '</span></span></div>' +
						'</div>';
						
			$('#' + widgetId).append("<div class='w3-border-bottom w3-padding-16 w3-hover-light-grey w3-hover-shadow' style='cursor: pointer;'>" + kbCard + "</div>");

			$('#kb' + kb.ArticleId).on("click", function(){
				window.open('/KnowledgeBase/View/' + kb.ArticleId, '_blank');
			});
			//Saves article id to target last element later to remove bottom border
			lastArticle = '#kb' + kb.ArticleId;

		});
		//Removes bottom border on last element
		$(lastArticle).parent().removeClass('w3-border-bottom');

	}
	
	
	type = $(widget).hasClass('featured') ? 'featured' : $(widget).hasClass('viewed') ? 'viewed' : '';
	
	switch (type) {
		case 'featured': {
			url = "/api/V3/Article/GetTopArticlesByPopularity?count=5";
			$(widget).parent().parent().parent().parent().prev().addClass('panelHeadingHover');
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').append('<span class="w3-right w3-margin-top w3-medium"><a href="/View/cca5abda-6803-4833-accd-d59a43e2d2cf">(Se alle)</a></span>');
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-book panel-title-icon"> </i>');
			widgetId = 'kbFeatured';
			break;
		}
		case 'viewed': {
			url = "/api/V3/Article/GetTopArticlesByViewCount?count=5";
			//console.log('articles by viewed');
			$(widget).parent().parent().parent().parent().prev().addClass('panelHeadingHover');
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').append('<span class="w3-right w3-margin-top w3-medium"><a href="/View/0aef4765-0efa-4a65-84c1-324b09231223">(Se alle)</a><span>');
			$(widget).parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-book panel-title-icon"> </i>');
			widgetId = 'kbViewed';
			break;
		}
		default: {
			url = "/api/V3/Article/GetTopArticlesByPopularity?count=5";
		}
	}
	$(widget).empty();
	$(widget).append('<div id="' + widgetId + '" class=""></div>');
	$(widget).parent().parent().parent().parent().attr("class", "w3-border w3-border-grey w3-round-large");
	
	$.get(url, function(data){
		
		buildKbList(data, widgetId);
		
		/*$.each(data, function(i,e){
			//
			$(widget).append('<div class="liArticle" id="kb' + e.ArticleId + '"><p class="liTitle">' + e.Title + '</p><p></p><p class="listDate">' + kendo.toString(new Date(e.LastModifiedDate.toString()), "g")  + '</p><p class="liBody">Rating: ' + e.Rating + '/5 </p><p class="listBody">Views: ' + e.ViewCount + '</p></div>');
			$('#kb' + e.ArticleId).on("click", function(){
				window.open('/KnowledgeBase/View/' + e.ArticleId, '_blank');
			});
		});*/
	});
}

//Widget with buttons for Incident, Service Request and Question 
function HowCanWeHelp (widget)
{
	//Clear the old widget to be sure its empty
	$(widget).empty();
	
	//Builds the html code
	var htmlString = '<div class="w3-row w3-padding-16">' +
						'<div class="w3-container w3-third">' +
							'<div class="w3-hover-light-grey w3-hover-shadow w3-border w3-border-red w3-round-large">' +
								'<div class="homepage-incident" >' +
									'<div class="w3-cell-row w3-center">' +
										'<span class="w3-cell" style="width:100px">' +
											'<img class="w3-section w3-margin-left" width="96px" height="96px" src="/CustomSpace/EndUserHome/Icons/MSConfigManage-02-WF_96px.svg">' +
										'</span>' +
										'<div class="w3-cell w3-xlarge w3-text-red"><div class="text-styling-bold">Jeg har et</div><div class="text-styling-bold" style="overflow-wrap: anywhere">problem</div></div>' +
									'</div>' +
									'<div class="w3-cell-row w3-container w3-center w3-margin-bottom">' +
										'<div class="w3-cell text-styling-description">Indberet fejl på computere, printere, telefoner, ipads, programmer, etc.</div>' +
									'</div>' +
								'</div>' +
							'</div>' +
						'</div>' +
						'<div class="w3-container w3-third">' +
							'<div class="w3-hover-light-grey w3-hover-shadow w3-border w3-border-green w3-round-large">' +
								'<div class="homepage-serviceRequest" >' +
									'<div class="w3-cell-row w3-center">' +
										'<span class="w3-cell" style="width:100px">' +
											'<img class="w3-section w3-margin-left" width="96px" height="96px" src="/CustomSpace/EndUserHome/Icons/AddComputer_96px.svg">' +
										'</span>' +
										'<div class="w3-cell w3-xlarge w3-text-green"><div class="text-styling-bold">Jeg har brug</div><div class="text-styling-bold">for noget</div></div>' +
									'</div>' +
									'<div class="w3-cell-row w3-container w3-center w3-margin-bottom">' +
										'<div class="w3-cell text-styling-description">IT-Services og bestilling af IT-udstyr, programmer, rettigheder, etc.</div>' +
									'</div>' +
								'</div>' +
							'</div>' +
						'</div>' +
						'<div class="w3-container w3-third">' +
							'<div class="w3-hover-light-grey w3-hover-shadow w3-border w3-border-blue w3-round-large">' +
								'<div class="homepage-question" >' +
									'<div class="w3-cell-row w3-center">' +
										'<span class="w3-cell" style="width:100px">' +
											'<img class="w3-section w3-margin-left" width="96px" height="96px" src="/CustomSpace/EndUserHome/Icons/UserHelp_96px.svg">' +
										'</span>' +
										'<div class="w3-cell w3-xlarge w3-text-blue"><div class="text-styling-bold">Jeg har et</div><div class="text-styling-bold" style="overflow-wrap: anywhere">spørgsmål</div></div>' +
									'</div>' +
									'<div class="w3-cell-row w3-container w3-center w3-margin-bottom">' +
										'<div class="w3-cell text-styling-description">Stil et spørgsmål til IT-Servicedesk omkring IT-udstyr og programmer</div>' +
									'</div>' +
								'</div>' +
							'</div>' +
						'</div>' +
					'</div>';
	
	//Add the code to the page
	$(widget).append(htmlString);
	//adjust the widget to make it align better
	$(widget).css("margin-top", "-2px")
	//Hides the default widget headline 
	$(widget).parent().parent().parent().parent().prev().css("display", "none");
	
	////Adds event handling on buttons
	//Onclick on Incident
	$('.homepage-incident').on("click", function(e){
		window.open("/View/94ecd540-714b-49dc-82d1-0b34bf11888f?so=d5ce1b6d-938e-7e1d-61a8-a233a1050f1a", "_self"); //the url to go to
	});
	//Onclick on Service Request
	$('.homepage-serviceRequest').on("click", function(e){
		window.open("/View/94ecd540-714b-49dc-82d1-0b34bf11888f?so=3e991117-af07-4e33-4330-2d5c1df579e3", "_self");
	});
	//Onclick on Question
	$('.homepage-question').on("click", function(e){
		window.open("/SC/ServiceCatalog/RequestOffering/821b2328-b050-e35b-e836-9124f4c26e84,b294e7b5-9efc-f537-57c6-2f54df443af9", "_self");
	});


	
}

//Widget with contact info 
function ContactInfo (widget)
{
	//Clear the old widget to be sure its empty
	$(widget).empty();

	//Build the html code for the widget				
	var htmlString = '<div name="contactInfo" class="w3-section">' +
						'<div class="w3-row w3-margin-top">' +
							'<div class="w3-cell w3-cell-middle"><img src="/CustomSpace/EndUserHome/Icons/Shop-Open.svg" width="72px" height="72px"></div>' +
							'<div class="w3-cell w3-cell-middle">' +
								'<p><span class="text-styling-bold">Mandag - torsdag:</span> 8:00 - 12:00 og 13:00 - 15:00</p>' +
								'<p><span class="text-styling-grey-bold">Onsdag lukket for personlig henvendelse</span></p>' +
								'<p><span class="text-styling-bold">Fredag:</span> 8:00 - 12:00</p>' +
							'</div>' +
						'</div>' +
						'<div class="w3-row">' +
							'<div class="w3-cell w3-cell-middle"><img src="/CustomSpace/EndUserHome/Icons/Hotline.svg" width="72px" height="72px"></div>' +
							'<div class="w3-cell w3-cell-middle">' +
								'<div>Ring på: <a href="tel:89701550" class="PhoneNumber">8970 1550</a></div>' +
							'</div>' +
						'</div>' +
						'<div class="w3-row">' +
							'<div class="w3-cell w3-cell-middle"><img src="/CustomSpace/EndUserHome/Icons/Man-01.svg" width="72px" height="72px"></div>' +
							'<div class="w3-cell w3-cell-middle">' +
								'<div>Vi har kontor på Søvej 1, 3. sal, bygning C</div>' +
							'</div>' +
						'</div>' +
					'</div>';
					
					
	//Adds the code to the page
	$(widget).append(htmlString);
	//Adjust the widget to align better
	$(widget).parent().parent().parent().parent().prev().css('margin-top', '44px');
	//Add icon before widget headline text
	$(widget).parent().parent().parent().parent().prev().children('div').children('h3').prepend('<i class="fa fa-comments-o panel-title-icon"> </i>');
	//Add rounded border around the contact info
	$(widget).parent().parent().parent().parent().attr("class", "w3-border w3-border-grey w3-round-large");

	
}

//Function to place the "my request" and "knowledge articles" widgets beside each other
function MoveArticles() {

	// variable to hold the "My Request" widget
	var myRequestsWidget = $('div[adf-id="object:69"]'); //uses object id to identify the widget - find it by using dev tools in browser
	// variable to hold the "Knowledge Article" widget
	var articleWidget = $('div[adf-id="object:102"]'); //uses object id to identify the widget - find it by using dev tools in browser
	
	//Build new html code to contain the two widgets
	var htmlString = '<div class="w3-row w3-margin-top">' +
						'<div class="w3-container w3-margin-top w3-half">' +
							'<div id="myRequestsMoved" class=""></div>' +
						'</div>' +
						'<div class="w3-container w3-margin-top w3-half">' +
							'<div id="articlesMoved" class=""></div>' +
						'</div>' +
					'</div>';
	
	//Add the new code before the "My Request" widget
	myRequestsWidget.before(htmlString);
	
	//Jquery moves the widget code automatically to the new place in the code just added
	$('#myRequestsMoved').append(myRequestsWidget);
	$('#articlesMoved').append(articleWidget);
}

$(document).ready(function() {
	function homeWidgets(){
		
		//Loads custom stylesheet into header (can be placed into custom.css instead)
		$("<link>", {
            type: "text/css",
            rel: "stylesheet",
            href: '/CustomSpace/EndUserHome/style.css',
        }).appendTo("head");
		
		//top - needs to find out what is does???
		$('.margin-t20').prev().hide();
		
		//Workitem Card widgets 
		$('.wiCardWidget').each(function(x,w) {
			wiCardWidget(w);
		})
		
		//HowCanWeHelp widget - service catalog
		$('.howCanWeHelp').each(function(i,e) {
			HowCanWeHelp(e);
		});	
		
		//Operation Status Widget - Uses the Announcement feature
		$('.operatingStatus').each(function(i,e) {
			OperatingStatus(e);
		});		
		
		//Contact Info widget
		$('.contactInfo').each(function(i,e) {
			ContactInfo(e);
		});		
	
		//articles
		$('.topArticles').each(function(i,e) {
			topArticles(e);
		});
		
		//Eventhandling when clicking on panel headers
		$('.panel-heading').each(function(i,e){
			$(e).click(function(){
				
				var headingText = $(this).text().toLowerCase();
				
				//Knowledge articles - go to Knowledge Article page
				if (headingText.indexOf("videns") > -1)
				{
					window.open('/View/0aef4765-0efa-4a65-84c1-324b09231223', '_self');
				}
				//My Work - Go to my work page
				else if (headingText.indexOf("mine opgaver") > -1)
				{
					window.open('/View/cca5abda-6803-4833-accd-d59a43e2d2cf', '_self');
				}
				//My Requests - go to My request page
				else if (headingText.indexOf("mine request") > -1)
				{
					window.open('/View/c5161e06-2378-4b44-aa89-5600e2d3b9d8', '_self');
				}
				//Operating Status - go to operating status page
				else if (headingText.indexOf("driftstatus") > -1)
				{
					window.open('/Page/7074e08a-ed22-46fa-b06f-9d59d90d5c70', '_self');
				}
				//Else do nothing - collapse function disabled
				else
				{
					//$(this).toggleClass('panel-collapse');
					//$(this).next().toggle();
				}
			});
		});
		
		//Move knowledge article side by side to My Requests
		MoveArticles();
		//Adjust top margin on right site column (Operating Status and Contact Info)
		$('div[adf-id="object:198"]').css("margin-top", "-32px");
		//Adjust the top margin on the contact info widget to align better
		$('div[adf-id="object:66"]').css("margin-top", "32px");
		
	};
	
	var mainPageNode = document.getElementById('main_wrapper');
	var observer = new MutationObserver(function(mutations) {
		if ($('.dashboard').length > 0) {
			homeWidgets();
			observer.disconnect();
		}
		else {
			return;
		}
	});
	var observerConfig = { attributes: true, childList: true, subtree: true, characterData: true };
	observer.observe(mainPageNode, observerConfig);
	
});

/* ------------------------------------------------------- */
/* ---------- End Custom Alternate End Use Home ---------- */
/* ------------------------------------------------------- */ 