/* ------------------------------------------------------- */
/* - Custom Add Inactive Items Link to Team Request View --*/
/* ------------------------------------------------------- */
// Author: Mikkel Madsen
// Contributor: Ryan Lane (SQL part and idea)
// Description: Add link/button to team request view to se inactive (completed, resolved, closed) team requests
//				Hides navigation node containing our custom page with inactive team requests 
//				NOTE: You also have to make a custom page with a SQL Table Widget and a new navigation node to contain your custom page	
// v0.1 initial release

(function(){ // Avoid Global variables where we can!

	//##################### CHANGE THESE VARIABLES TO MATCH YOUR SETTINGS #########################################//
	var inactivePageId 	= '59a17f38-a32b-4a84-8479-f794e4984737'; // The id of your custom page
	var hiddenNodeName 	= 'Hidden Node'; // The name of the navigation node we want to hide from navigation menu
	var pageTitle		= 'Team Requests'; //The title of your custom page
	var resStateLocName = 'Nulstil tilstand'; //If using an other language than English, provide with your locale value equals to the English "Reset State" : Note case sensitive! 
	//################# DO NOT EDIT BELOW IF YOU DONT KNOW WHAT YOU ARE DOING! ####################################//

	
	$(document).ready(function () {

		var url = window.location.href;
        
		//The navigation node doesn't load immediately. Get the main div that definitely exists.
        var mainPageNode = document.getElementById('main_wrapper');
	
		var observerHideNode = new MutationObserver(function(mutations) {

			var navMenu = $('#side_nav');

			if (navMenu.length > 0) { //An Element Exists
				//Hide the navigation node with the custom page in from the navigation bar
				$('nav > ul > li > a > span').each(function (index) {
					if($(this).text() == hiddenNodeName){
						$(this).parent().parent().css('display', 'none');
					}
				});

				observerHideNode.disconnect();
			}
		});

		// configure the observer and start the instance.
		var observerHideNodeConfig = {attributes: true, childList: true, subtree: true, characterData: true };
		observerHideNode.observe(mainPageNode, observerHideNodeConfig);
		
		
		// Verify we are on team request page with a gridview.
        if(url.indexOf("9a06b0af-2910-4783-a857-ba9e0ccb711a") > -1 ) { 
            
            // create an observer instance
            var inactiveTeamRequest = new MutationObserver(function(mutations) {
                //The page changed. See if our export button exist. 
				var exportBtn = $('.k-header.k-grid-toolbar');

				if(exportBtn.length > 0) {       

					//Add buttons to view
					exportBtn.append('<ul class="nav nav-pills toolbar-tabs"><li class="active"><a href="/view/9a06b0af-2910-4783-a857-ba9e0ccb711a">Active</a></li><li><a href="/page/' + inactivePageId + '">Inactive</a></li></ul>');
							  
					//We are done observing.
					inactiveTeamRequest.disconnect();
						
				}
                
            });
            
            // configure the observer and start the instance.
            var inactiveTeamRequestConfig = { attributes: true, childList: true, subtree: true, characterData: true };
            inactiveTeamRequest.observe(mainPageNode, inactiveTeamRequestConfig);
        }
		
		// Verify we are on our new inactive team request page with a gridview.
		if(url.indexOf(inactivePageId) > -1 ) { 

            // create an observer instance
            var inactiveTeamRequestPage = new MutationObserver(function(mutations) {
                //The page changed. See if #reset state# button exist. 
				var resetBtn = $('a:contains("Reset State")');
				// If reset state button not found we try the localized name
				if (resetBtn.length < 1){
					resetBtn = $('a:contains("' + resStateLocName + '")'); //Note to self: case sensitive search - see correct name to search for in dev tools
				}
				
				if(resetBtn.length > 0) {       
		        			console.log("Custom Add Inactive Items: We have a length");	

					//Add buttons to view
					resetBtn.parent().attr('class', 'k-header k-grid-toolbar');
					resetBtn.parent().append('<ul class="nav nav-pills toolbar-tabs"><li><a href="/view/9a06b0af-2910-4783-a857-ba9e0ccb711a">Active</a></li><li class="active"><a href="/page/' + inactivePageId + '">Inactive</a></li></ul>');
					resetBtn.attr('class', 'k-button pull-right btn btn-default btn-clear-grid-filters');		  
					
					//Styles page title as Team Requests page title
					var titleElement = $('h3:contains("' + pageTitle + '")');
					titleElement.attr('style', 'font-size: 27px;color: rgb(0,0,0);font-weight:700');
					
					inactiveTeamRequestPage.disconnect();
						
				}
                
            });
            
            // configure the observer and start the instance.
            var inactiveTeamRequestPageConfig = { attributes: true, childList: true, subtree: true, characterData: true };
            inactiveTeamRequestPage.observe(mainPageNode, inactiveTeamRequestPageConfig);
        }

    });

 
})();
/* ------------------------------------------------------- */
/* End Custom Add Inactive Items Link to Team Request View */
/* ------------------------------------------------------- */