//#########################################################//
/* ------------------------------------------------------- */
/* ------------ Custom Announcement Templates ------------ */
/* ------------------------------------------------------- */
// Tested with portal v10.0.0.2016
// Tested with in Edge Chromium
// Contributors: Mikkel Madsen, Justin Workman
// Description: Adds a template function to announcement editor by adding a drop downlist functionality to the editor toolbar
// Notes: This script uses the W3.CSS framework - add it to your stylesheet to make it work correctly - se more: https://www.w3schools.com/w3css/default.asp
// v0.1 initial release

$(document).ready(function() {
	
	//Array of template names to be displayed in drop down list. Names has to match corresponding filename in template folder
	var templateFileNames = ["Ny driftsforstyrrelse", "Opdater status", "Fejlen er løst", "Planlagt driftsforstyrrelse"];
	//The url path to where template files are stored
	var templateFolderPath = '/CustomSpace/AnnouncementTemplates/Templates/';
	
	//Adds dropdown list to the editor
	function TemplateButton(){
				
			
			dropDownButton = '<li class="k-tool-group k-button-group" role="presentation">' + 
								'<div class="w3-dropdown-hover">' + 
									'<button class="j-button">Apply Template <i class="fa fa-caret-down"></i></button>' +
									'<div id="templates" class="w3-dropdown-content w3-bar-block w3-light-grey" style="width: 150px">';

			//goes trough the array with filenames and adds an entry to the dropdown list
			for (i = 0; i < templateFileNames.length; i++) {
				dropDownButton += 		'<span id="template' + i + '" name="template" class="w3-bar-item w3-button">' + templateFileNames[i] + '</span>'
			}

			dropDownButton += 		'</div>' +
								'</div>' + 
							'</li>';
			
			//adds the dropdown list/button to the editor toolbar
			$('ul[data-role="editortoolbar"]').append(dropDownButton);
			
			//adds eventhandling when clicking on an entry in the dropdownlist
            $('[name="template"]').click(function(i) {
				AddTemplate($(this).text());
            })
	}


	//Add template content to the editor
    function AddTemplate(tName) {
		//creates a new date object to make intelligent timestamps replacements in the template code.
		var currentTime = new Date();
		//current timpestamp
		var cTimestamp = kendo.toString(new Date(currentTime), "HH:mm");
		
		//next update timestamp = current + 1 hour
		var nTimestamp = currentTime.setHours(currentTime.getHours() + 1);
		nTimestamp = kendo.toString(new Date(nTimestamp), "HH:mm");
		
		//get the kendoeditor
		var kedit = $('[name="Body"]').data('kendoEditor');
		var storedRange = kedit.getRange();
		kedit.selectRange(storedRange);
		
		//the url to the template that we want to apply
		tUrl = templateFolderPath + tName + '.html'
        
		//get the template code
		$.get(tUrl, function(templateHTML) {
			//substitute "{{timestamp}}" in template code with current timestamp
			var tHTML = templateHTML.replace("{{timestamp}}", cTimestamp);
			//substitute "{{nextStatus}}" in template code with nextStatus timestamp
			var tHTML = tHTML.replace("{{nextStatus}}", nTimestamp);
			//apply the template code to the editor
			kedit.exec('inserthtml', { value: tHTML});
		}).fail(function() {
			//if the template file does not exist
			var failHTML = "<h1>No template for " + tName + "</h1>"
			kedit.exec('inserthtml', { value: failHTML});
		});
        
	};
	
	//Adds observer to make sure that the editortoolbar exist before adding the dropdown button
	var mainPageNode = document.getElementById('main_wrapper');
	var observer = new MutationObserver(function(mutations) {
		if ($('ul[data-role="editortoolbar"]').length > 0) {
			observer.disconnect();
			TemplateButton();
		}
		else {
			return;
		}
	});
	
	var observerConfig = { attributes: true, childList: true, subtree: true, characterData: true };
	observer.observe(mainPageNode, observerConfig);
   
});


/* ------------------------------------------------------- */
/* ---------- End Custom Announcement Templates ---------- */
/* ------------------------------------------------------- */ 